<?php
// Configure session to be persistent for a long time (10 years)
if (session_status() === PHP_SESSION_NONE) {
    session_set_cookie_params([
        'lifetime' => 315360000, // 10 years in seconds
        'path' => '/',
        'domain' => '',
        'secure' => false, // Changed to false for local testing
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
    session_start();
}

// For local testing, create a mock admin user if a specific parameter is provided
if (isset($_GET['local_admin']) && $_GET['local_admin'] === '1') {
    $_SESSION['user'] = [
        'login' => 'admin',
        'name' => 'Local Administrator'
    ];
    header("Location: admin.php");
    exit;
}

function checkAuth($api_token) {
    // Check if we have a cached result
    $cache_key = 'auth_cache_' . md5($api_token);
    if (isset($_SESSION[$cache_key])) {
        // Return cached result - now cached permanently unless explicitly invalidated
        if ($_SESSION[$cache_key]['user'] !== false) {
            return $_SESSION[$cache_key]['user'];
        }
        // For negative cache, still check periodically (every hour)
        if (time() - ($_SESSION[$cache_key]['timestamp'] ?? 0) < 3600) {
            return $_SESSION[$cache_key]['user'];
        }
    }
    
    $url = AUTH_API_URL . '&api_token=' . urlencode($api_token);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Set timeout to 10 seconds
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); // Set connection timeout to 5 seconds
    curl_setopt($ch, CURLOPT_USERAGENT, 'Archive.DuDu2/1.0');
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($http_code === 200 && $response) {
        $data = json_decode($response, true);
        if (isset($data['status']) && $data['status'] === 'success') {
            // Cache the result permanently
            $_SESSION[$cache_key] = [
                'user' => $data['user'],
                'timestamp' => time()
            ];
            return $data['user'];
        }
    }
    
    // Cache negative results for a shorter period to avoid repeated failed calls
    $_SESSION[$cache_key] = [
        'user' => false,
        'timestamp' => time()
    ];
    return false;
}

$errors = [];
$success = '';
$user = null;

if (isset($_GET['api_token'])) {
    $api_token = trim($_GET['api_token']);
    $user = checkAuth($api_token);
    if ($user) {
        $_SESSION['user'] = $user;
        $_SESSION['api_token'] = $api_token;
        // Redirect to clean URL without token in address bar
        header("Location: index.php");
        exit;
    } else {
        $errors[] = 'Неверный API-токен или неподтвержденный email';
    }
}

if (isset($_SESSION['api_token']) && !isset($user)) {
    // Check if we have a valid user in session already
    if (isset($_SESSION['user'])) {
        $user = $_SESSION['user'];
    } else {
        // Only check with auth server if we don't have user data cached
        $cache_key = 'auth_cache_' . md5($_SESSION['api_token']);
        if (!isset($_SESSION[$cache_key]) || $_SESSION[$cache_key]['user'] === false) {
            $user = checkAuth($_SESSION['api_token']);
            if ($user) {
                $_SESSION['user'] = $user;
            } else {
                unset($_SESSION['user'], $_SESSION['api_token']);
            }
        } else {
            $user = $_SESSION[$cache_key]['user'];
            $_SESSION['user'] = $user;
        }
    }
}

if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    // Clear auth cache on logout
    foreach ($_SESSION as $key => $value) {
        if (strpos($key, 'auth_cache_') === 0) {
            unset($_SESSION[$key]);
        }
    }
    unset($_SESSION['user'], $_SESSION['api_token']);
    session_destroy();
    header("Location: index.php");
    exit;
}